/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.postgresql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.export.CsvExporter;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.postgresql.PostgresqlTableModelGenerator;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.exception.InvalidStateException;
import jtbcore.util.DateUtil;

public class PostgresqlConnection
extends SqlConnection {
    protected Boolean integratedSecurity;
    protected String host;
    protected String username;
    protected String password;
    protected String databaseName;
    protected SqlDatabase sqlDb = null;

    public PostgresqlConnection() {
        this.START_VAL = (char)34;
        this.STOP_VAL = (char)34;
    }

    public Boolean getIntegratedSecurity() {
        return this.integratedSecurity;
    }

    public void setIntegratedSecurity(Boolean integratedSecurity) {
        this.integratedSecurity = integratedSecurity;
    }

    public String getHost() {
        if (this.host == null || this.host.trim().length() == 0) {
            return "localhost";
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public void connect() throws SQLException, InvalidStateException {
        Connection con = null;
        Properties props = new Properties();
        props.setProperty("user", this.username);
        props.setProperty("password", this.password);
        String host = this.host;
        if (host == null || this.host.trim().length() == 0) {
            host = "localhost";
        }
        String url = "jdbc:postgresql://" + host + "/" + this.databaseName;
        this.connection = con = DriverManager.getConnection(url, props);
    }

    @Override
    public void initModel(DatabaseModel model) throws SQLException, IOException {
        PostgresqlTableModelGenerator modgen = new PostgresqlTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0) {
            this.sqlDb = null;
        }
    }

    @Override
    public void updateTable(TableModel t) throws SQLException, IOException {
        DatabaseModel model = new DatabaseModel();
        t.setAutogenerated(true);
        model.addTable(t);
        PostgresqlTableModelGenerator modgen = new PostgresqlTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0 && this.sqlDb != null) {
            for (TableModel tm : updatedTables) {
                SqlTable qt = modgen.buildSqlTable(this, tm.getSchemaName(), tm.getName());
                this.sqlDb.addTable(qt);
            }
        }
    }

    @Override
    public SqlDatabase getSqlDatabase() throws IOException, SQLException {
        if (this.sqlDb == null) {
            PostgresqlTableModelGenerator gen = new PostgresqlTableModelGenerator();
            this.sqlDb = gen.postgresToSqlDatabase(this);
        }
        return this.sqlDb;
    }

    @Override
    public void resetSqlDatabase() {
        this.sqlDb = null;
    }

    @Override
    public Integer insertQuery(String sql, Object ... args) throws SQLException {
        ResultSet rs = super.queryResultSet(sql + " RETURNING *", args);
        Integer v = null;
        try {
            if (rs.next()) {
                v = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        rs.close();
        return v;
    }

    @Override
    public void truncateTable(String tblname) throws SQLException {
        this.query("truncate table " + tblname + " RESTART IDENTITY", new Object[0]);
    }

    public static void main(String[] args) {
        try {
            PostgresqlConnection c = new PostgresqlConnection();
            c.setUsername("timvw");
            c.setPassword("uiz");
            c.setHost("localhost");
            c.setDatabaseName("dumptest");
            c.connect();
            PreparedStatement ps = c.prepareStatement("SELECT *\r\n\tFROM eodump.eo_crm_accounts", new Object[0]);
            ResultSet rs = ps.executeQuery();
            CsvExporter e = new CsvExporter("/home/timvw/test.csv");
            e.export(rs);
            ps.close();
            System.out.println("Test: " + String.valueOf(e.getColumnsExported()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Object castColValue(SqlColumn sqlCol, String colval) {
        if (colval == null) {
            return colval;
        }
        if (sqlCol.internalType == SqlColumn.DataType.DATE) {
            Date d = DateUtil.string2datetime(colval);
            if (d == null) {
                return null;
            }
            Timestamp t = new Timestamp(d.getTime());
            return t;
        }
        return super.castColValue(sqlCol, colval);
    }
}

